# -*- coding: utf-8 -*-
"""
Created on Sat Apr 17 19:04:48 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
import datetime
import pathlib
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
#data_folder_name = 'data'
#data_folder_path = os.path.join(main_folder_path,data_folder_name)
data_folder_path = main_folder_path
#export_folder_name = 'Misc plots'
#export_folder_path = os.path.join(main_folder_path,export_folder_name)
export_folder_path = main_folder_path
#if not os.path.exists(export_folder_path):
#    os.mkdir(export_folder_path) # create folder if non-existent

file_path_abs = os.path.join(data_folder_path,'absorbance.csv')
file_path_pl = os.path.join(data_folder_path,'pl spectrum.csv')
file_path_el = os.path.join(data_folder_path,'el spectrum.csv')
    
"""Prepare data"""
label_strings = ['Absorbance',\
                 'PL',\
                 'EL']

abs_df = pd.read_csv(file_path_abs)
pl_df = pd.read_csv(file_path_pl)
el_df = pd.read_csv(file_path_el)

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8    

"""Create figures"""
fig = plt.figure(0, figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])
ax_twin = ax.twinx()
ax.set_xlabel('Wavelength [nm]')
ax.set_ylabel('Absorbance')
ax_twin.set_ylabel('Intensity (normalized)')
    
# =============================================================================
# fig_log = plt.figure(1)
# fig_log.set_size_inches(10,8)
# fig_log.set_tight_layout(True)
# ax_log = plt.gca()
# ax_log_twin = ax_log.twinx()
# ax_log.set_xlabel('Wavelength [nm]')
# ax_log.set_ylabel('Absorbance')
# ax_log_twin.set_ylabel('Intensity (normalized)')
# =============================================================================

"""Plot the data"""
line_pl = ax_twin.plot(pl_df['nm'], pl_df['normalized intensity'], color=COLOURS_GREENS[250],  label=label_strings[1])
line_el = ax_twin.plot(el_df['nm'], el_df['normalized intensity'], '--', color=COLOURS_GREENS[800], label=label_strings[2])
line_abs = ax.plot(abs_df['nm'], abs_df['absorbance'], color='k', label=label_strings[0])
# =============================================================================
# ax_log_twin.semilogy(pl_df['nm'], pl_df['normalized intensity'], color=COLOURS_GREENS[250], label=label_strings[1])
# ax_log_twin.semilogy(el_df['nm'], el_df['normalized intensity'], color=COLOURS_GREENS[800], label=label_strings[2])
# ax_log.semilogy(abs_df['nm'], abs_df['absorbance'], color='k', label=label_strings[0])
# =============================================================================

"""Annotation"""
ax.annotate("",
            xy=(0.558, 0.45), xycoords='axes fraction',
            xytext=(0.408, 0.45), textcoords='axes fraction',
            arrowprops=dict(facecolor='black', width=lw),
            )
ax.annotate("",
            xy=(0.05, 0.66), xycoords='axes fraction',
            xytext=(0.2, 0.66), textcoords='axes fraction',
            arrowprops=dict(facecolor='black', width=lw),
            )


"""Set axis values"""
ax.set_xlim(left = 420, right = 700)
ax.set_ylim(bottom = 0, top = 0.2)
ax_twin.set_ylim(bottom = -0.05, top = 1.05)
# =============================================================================
# ax_log.set_xlim(left = 420, right = 700)
# ax_log.set_ylim()
# ax_log_twin.set_ylim(bottom = 5e-4)
# =============================================================================
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(0.05))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.025))
ax_twin.yaxis.set_major_locator(mpl.ticker.MultipleLocator(1))
ax_twin.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.1))

"""Legend"""
# Making sure all lines are on the same legend
lines = line_pl + line_el + line_abs
labels = [l.get_label() for l in lines]
leg = ax.legend(lines, labels, frameon = False)
# =============================================================================
# ax_log.legend()
# =============================================================================

# Right-aligning the legend
vp = leg._legend_box._children[-1]._children[0]
for c in vp._children:
    c._children.reverse()
vp.align="right"

"""Arrange plots"""
# Absorbance in front
ax.set_zorder(1)  # default zorder is 0 for ax1 and ax2
ax.patch.set_visible(False)  # prevents ax1 from hiding ax2

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5


ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax_twin.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax_twin.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

# =============================================================================
# ax_log.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
# ax_log.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
# ax_log.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
# ax_log.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
# ax_log_twin.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
# ax_log_twin.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
# =============================================================================

"""Exporting plots"""
plot_name = 'Plot UV-vis PL EL'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)
